#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
	namespace gov.va.med.vbecs.BOL.UnitTests
	{
		[TestFixture]
		public class BOL_DivisionCollection  : BaseTest 
		{
			[Test]
			public void Ctor_Pass()
			{
				Assert.IsNotNull( new DivisionCollection() );
				Assert.AreEqual( 0, new DivisionCollection().Count );
			}

			[Test]
			[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
			public void Ctor_Fail() {}

			[Test]
			public void Add_Pass()
			{				
				DivisionCollection _testCollection = new DivisionCollection();
				Division _divToAdd = GetTestDivision();

				Assert.AreEqual( _divToAdd, _testCollection.Add( _divToAdd ) );
				Assert.AreEqual( 1, _testCollection.Count );
			}

			[Test]
			[ExpectedException(typeof(ArgumentNullException))]
			public void Add_Fail()
			{
				new DivisionCollection().Add( null );
			}

			[Test]
			public void Indexer_Pass()
			{
				DivisionCollection _testCollection = new DivisionCollection();
				Division _divToAdd = GetTestDivision();
				_testCollection.Add( _divToAdd );

				Assert.AreEqual( _divToAdd, _testCollection[0] );
			}

			[Test]
			[ExpectedException(typeof(ArgumentOutOfRangeException))]
			public void Indexer_Fail()
			{
				Division _div = (new DivisionCollection())[-1];
			}

			[Test]
			public void IndexOf_Pass_1()
			{
				DivisionCollection _testCollection = new DivisionCollection();
				_testCollection.Add( GetAdditionalTestDivision() );

				Division _testDiv = GetTestDivision();
				_testCollection.Add( _testDiv );

				Assert.IsTrue( _testCollection.IndexOf( _testDiv ) >= 0 );
			}

			[Test]
			public void IndexOf_Pass_2()
			{
				DivisionCollection _testCollection = new DivisionCollection();
				_testCollection.Add( GetTestDivision() );

				Assert.AreEqual( -1, _testCollection.IndexOf( GetAdditionalTestDivision() ) );
			}

			[Test]
			[Ignore( StandardIgnoreReasons.NoFailureConditions )]
			public void IndexOf_Fail() {}

			private static Division GetTestDivision()
			{
				return GetTestDivisionByIndex( 0 );
			}

			private static Division GetAdditionalTestDivision()
			{
				return GetTestDivisionByIndex( 1 );
			}

			private static Division GetTestDivisionByIndex( int index )
			{
				DivisionBase _divBase = (DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[ index ];
				return new BOL.Division( _divBase.DivisionCode );
			}
		}
	}
#endif
